<?php

namespace App\Http\Requests\SuperAdmin\Patients;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'description' => 'nullable|string',
            'is_active' => 'nullable|in:1',
            'user_name' => 'required|alpha_dash|unique:patients,user_name,'.$this->patient->id,
        ];
    }
}
